require "BuildingObjects/ISBuildingObject"

HCSandBagBarricade = ISBuildingObject:derive("HCSandBagBarricade");

function HCSandBagBarricade:create(x, y, z, north, sprite, spriteN)
	local cell = getWorld():getCell();
	local eHP = getSpecificPlayer(self.player):getPerkLevel(Perks.Woodwork)*2000;
	local objHP = 4000 + eHP;
	if getSpecificPlayer(self.player):HasTrait("Handy") then
		objHP = objHP + 100;
	end
	self.sq = cell:getGridSquare(x, y, z);
	self.javaObject = IsoThumpable.new(cell, self.sq, sprite, north, self);
	buildUtil.setInfo(self.javaObject, self);
	local self2 = self;
	self2.modData["need:Hydrocraft.HCSandbagbarricade"] = "1";
	buildUtil.consumeMaterial(self2);
	self2 = nil;
	self.javaObject:setMaxHealth(objHP);
	self.javaObject:setBreakSound("breakdoor");
	self.sq:AddSpecialObject(self.javaObject);
	self.sq:RecalcAllWithNeighbours(true);
	self.javaObject:transmitCompleteItemToServer();
end

function HCSandBagBarricade:new(sprite, spriteN, player)
	local o = {};
	setmetatable(o, self);
	self.__index = self;
	o:init();
	o:setSprite(sprite);
	o:setNorthSprite(spriteN);
	o.name = "Sand Bag Barricade";
	o.canBarricade = false;
	o.dismantable = false;
	o.blockAllTheSquare = true;
	o.canBeAlwaysPlaced = false;
	o.noNeedHammer = true;
	o.character = player;
	return o;
end

function HCSandBagBarricade.onDestroy(thump, player)
	if thump:getName() ~= "Sand Bag Barricade" then return end
	for x=0, ZombRand(2) do
		thump:getSquare():AddWorldInventoryItem("Hydrocraft.HCWireconcertina", 0.0, 0.0, 0.0);
	end
	for x=0, 2+ZombRand(4) do
		thump:getSquare():AddWorldInventoryItem("Base.Sandbag", 0.0, 0.0, 0.0);
	end
	thump:getSquare():transmitRemoveItemFromSquare(thump);
	thump:getSquare():RemoveTileObject(thump);
end

function HCSandBagBarricade:render(x, y, z, square)
	ISBuildingObject.render(self, x, y, z, square);
end

Events.OnDestroyIsoThumpable.Add(HCSandBagBarricade.onDestroy);